# Requirements and compatibility

This page contains information on system requirements and compatibility of this package.

## Unity Editor compatibility

The following table shows the compatibility of URP package versions with different Unity Editor versions.

| Package version | Minimum Unity version | Maximum Unity version |
|-----------------|-----------------------|-----------------------|
| 10.7.x          | 2020.3.13f1           | 2020.3.x              |
| 10.6.x          | 2020.3.4f1            | 2020.3.x              |
| 10.5.x          | 2020.3.4f1            | 2020.3.x              |
| 10.4.x          | 2020.2.7f1            | 2020.3.x              |
| 10.3.x          | 2020.2.3f1            | 2020.2.x              |
| 10.2.x          | 2020.2.0b8            | 2020.2.x              |
| 10.1.x          | 2020.2.0b8            | 2020.2.x              |
| 10.0.x          | 2020.2.0a20           | 2020.2.x              |
| 9.x.x           | 2020.1.0b6            | 2020.2.x              |
| 8.2.x           | 2020.1.0b6            | 2020.1.x              |
| 8.1.x           | 2020.1.0b6            | 2020.1.x              |
| 8.0.x           | 2020.1.0a23           | 2020.1.x              |
| 7.4.x           | 2019.3.2f1            | 2019.4.x              |
| 7.3.x           | 2019.3.2f1            | 2019.4.x              |
| 7.2.x           | 2019.3.0f6            | 2019.4.x              |
| 7.1.8           | 2019.3.0f3            | 2019.4.x              |

## Render pipeline compatibility

Projects made using URP are not compatible with the High Definition Render Pipeline (HDRP) or the Built-in Render Pipeline. Before you start development, you must decide which render pipeline to use in your Project. For information on choosing a render pipeline, see the [Render Pipelines](https://docs.unity3d.com/2019.3/Documentation/Manual/render-pipelines.html) section of the Unity Manual.

## Unity Player system requirements

This package does not add any extra platform-specific requirements. General system requirements for the Unity Player apply. For more information on Unity system requirements, see [System requirements for Unity](https://docs.unity3d.com/Manual/system-requirements.html).
