using UnityEditor;
using UnityEngine;

namespace Unity.VisualScripting
{
    public class VSSettingsCustomProperty
    {
        private const string title = "Custom Inspector Properties";
        private const string buttonLabel = "Generate";

        public void OnGUI()
        {
            GUILayout.Space(5f);

            GUILayout.Label(title, EditorStyles.boldLabel);

            GUILayout.Space(5f);

            string label = "Inspectors in Bolt plugins can handle many custom types besides Unity primites and objects. ";
            label += "However, to be compatible with your custom editor drawers, some additional property provider scripts must be generated. ";

            GUILayout.BeginHorizontal(EditorStyles.helpBox);
            GUILayout.Label(EditorGUIUtility.IconContent("console.infoicon"), GUILayout.ExpandWidth(true));
            GUILayout.Box(label, EditorStyles.wordWrappedLabel);
            GUILayout.EndHorizontal();

            if (GUILayout.Button(buttonLabel, Styles.defaultsButton))
            {
                SerializedPropertyProviderProvider.instance.GenerateProviderScripts();
                EditorUtility.DisplayDialog("Custom Inspector Generation", "Custom inspector generation has completed successfully.", "OK");
            }
        }

        public static class Styles
        {
            static Styles()
            {
                defaultsButton = new GUIStyle("Button");
                defaultsButton.padding = new RectOffset(10, 10, 4, 4);

                regenerateLabel = new GUIStyle(EditorStyles.centeredGreyMiniLabel);
                regenerateLabel.wordWrap = true;
            }

            public static readonly GUIStyle defaultsButton;
            public static readonly GUIStyle regenerateLabel;
        }
    }
}
