#Version Control

| **Note**                                                     |
| :----------------------------------------------------------- |
| For versions 2019/2020 LTS, download the visual scripting solution from the [Unity Asset Store](https://assetstore.unity.com/packages/tools/visual-bolt-163802). |

Visual scripting plugin files should be excluded from version control. This minimizes the size of the commits and makes for cleaner commits.

Note: If you're using a public repository for your project, you must exclude visual scripting files with the instructions below. If you don't, you are illegally redistributing visual scripting online and breaking the Unity Asset Store EULA and ToS.

###Excluding files

To exclude files from your version control solution, the standard approach is to include a file that specifies which files and folders to exclude.

Place this file at the root of the project folder, above the Assets folder.

*   For Git, name this file .gitignore
*   For Unity Collab, name this file .collabignore
*   For Subversion, [ignore the files manually](https://stackoverflow.com/questions/86049/how-do-i-ignore-files-in-subversion)

Note: It is forbidden to create files in Windows Explorer without a filename. To do so, [rename the file](https://stackoverflow.com/questions/10744305/how-to-create-gitignore-file).

###Ignoring file template

The ignore file template ignores all core visual scripting files while preserving project settings and variables. It also includes the [standard Unity ignore directives](https://github.com/github/gitignore/blob/master/Unity.gitignore) for files that shouldn't be versioned.  

The transient section can be commented on or off. If unsure, leave the section enabled.

```
    ## Bolt

    # Optionally exclude these transient (generated) files, 
    # because they can be easily re-generated by the plugin

    Assets/Bolt.Generated/VisualScripting.Flow/UnitOptions.db
    Assets/Bolt.Generated/VisualScripting.Flow/UnitOptions.db.meta
    Assets/Bolt.Generated/VisualScripting.Core/Property Providers
    Assets/Bolt.Generated/VisualScripting.Core/Property Providers.meta

    ## Unity
    # From: https://github.com/github/gitignore/blob/master/Unity.gitignore

    [Ll]ibrary/
    [Tt]emp/
    [Oo]bj/
    [Bb]uild/
    [Bb]uilds/
    Assets/AssetStoreTools*

    # Visual Studio cache directory
    .vs/

    # Autogenerated VS/MD/Consulo solution and project files
    ExportedObj/
    .consulo/
    *.csproj
    *.unityproj
    *.sln
    *.suo
    *.tmp
    *.user
    *.userprefs
    *.pidb
    *.booproj
    *.svd
    *.pdb
    *.opendb

    # Unity3D generated meta files
    *.pidb.meta
    *.pdb.meta

    # Unity3D Generated File On Crash Reports
    sysinfo.txt

    # Builds
    *.apk
    *.unitypackage

```

####Removing ignored files

If you previously committed files that should be exluded, you can use the following Git commands to create a commit that removes them:

```
    git rm -r --cached . 
    git add .
    git commit -am "Remove ignored files"
```

Note: If you have pushed the files to a public repository, this procedure does not erase them from the commit history; you are still illegally redistributing the visual scripting files. Either make your repository private or start a new repository with a fresh tree that never included the visual scripting files.
