* [Universal Render Pipeline](index.md)
* [Requirements](requirements.md)
  * [Building for Closed platforms](Building-For-Consoles.md)
* [What's new in URP](whats-new/urp-whats-new.md)
* [Features]()
  * [Feature Comparison with the Built-in Render Pipeline](universalrp-builtin-feature-comparison.md)
* [Getting started](InstallingAndConfiguringURP.md)
  * [Create a Project from a Template](creating-a-new-project-with-urp.md)
  * [Install URP into an existing Project](InstallURPIntoAProject.md)
  * [Package samples](package-samples.md)
    * [URP Package Samples](package-sample-urp-package-samples.md)
  * [Scene Templates](scene-templates.md)
* [Render Pipeline Concepts](urp-concepts.md)
  * [The URP Asset](universalrp-asset.md)
  * [URP Global Settings](urp-global-settings.md)
  * [Universal Renderer](urp-universal-renderer.md)
  * [Deferred Rendering Path](rendering/deferred-rendering-path.md)
  * [Renderer Feature](urp-renderer-feature.md)
    * [How to add a Renderer Feature](urp-renderer-feature-how-to-add.md)
    * [Render Objects Renderer Feature](renderer-features/how-to-custom-effect-render-objects.md)
    * [Ambient Occlusion](post-processing-ssao.md)
    * [Decal](renderer-feature-decal.md)
      * [Decal Shader Graph](decal-shader.md)
* [Upgrade guides](upgrade-guides.md)
  * [Render Pipeline Converter](features/rp-converter.md)
  * [Upgrading to URP 12.0.x](upgrade-guide-2021-2.md)
  * [Upgrading to URP 11.0.x](upgrade-guide-11-0-x.md)
  * [Upgrading to URP 10.1.x](upgrade-guide-10-1-x.md)
  * [Upgrading to URP 10.0.x](upgrade-guide-10-0-x.md)
  * [Upgrading to URP 9.0.x](upgrade-guide-9-0-x.md)
  * [Upgrading to URP 8.2.0](upgrade-guide-8-2-0.md)
  * [Upgrading to URP 8.1.0](upgrade-guide-8-1-0.md)
  * [Upgrading to URP 8.0.0](upgrade-guide-8-0-0.md)
  * [Upgrading to URP 7.4.0](upgrade-guide-7-4-0.md)
  * [Upgrading to URP 7.3.0](upgrade-guide-7-3-0.md)
  * [Upgrading to URP 7.2.0](upgrade-guide-7-2-0.md)
  * [Upgrading from LWRP to URP](upgrade-lwrp-to-urp.md)
* [Rendering](rendering-in-universalrp.md)
  * [How to use Render Objects Renderer Feature](containers/how-to-custom-effect-render-objects.md)
* [Lighting](lighting.md)
  * [Light component reference](light-component.md)
  * [Lighting Mode](urp-lighting-mode.md)
  * [The Universal Additional Light Data component](universal-additional-light-data.md)
  * [Shadows in the Universal Render Pipeline](Shadows-in-URP.md)
  * [Reflection probes](lighting/reflection-probes.md)
  * [Light Layers](lighting/light-layers.md)
  * [Lens Flare asset](shared/lens-flare/lens-flare-asset.md)
* [Cameras](cameras.md)
  * [The Universal Additional Camera Data component](universal-additional-camera-data.md)
  * [Render Type](camera-types-and-render-type.md)
  * [Working with multiple cameras](cameras-multiple.md)
    * [Camera Stacking](camera-stacking.md)
    * [Rendering from multiple Cameras to the same render target](rendering-to-the-same-render-target.md)
    * [Rendering to a Render Texture](rendering-to-a-render-texture.md)
  * [Clearing, rendering order and overdraw](cameras-advanced.md)
  * [Camera component reference](camera-component-reference.md)

* [Post-processing](integration-with-post-processing.md)
  * [How to configure](integration-with-post-processing.md#post-proc-how-to)
  * [Volumes](Volumes.md)
    * [Volume Profile](VolumeProfile.md)
    * [Volume Overrides](VolumeOverrides.md)
  * [Effect List](EffectList.md)
    * [Ambient Occlusion](post-processing-ssao.md)
    * [Bloom](post-processing-bloom.md)
    * [Channel Mixer](Post-Processing-Channel-Mixer.md)
    * [Chromatic Aberration](post-processing-chromatic-aberration.md)
    * [Color Adjustments](Post-Processing-Color-Adjustments.md)
    * [Color Curves](Post-Processing-Color-Curves.md)
    * [Depth of Field](post-processing-depth-of-field.md)
    * [Film Grain](Post-Processing-Film-Grain.md)
    * [Lens Distortion](Post-Processing-Lens-Distortion.md)
    * [Lift, Gamma, and Gain](Post-Processing-Lift-Gamma-Gain.md)
    * [Motion Blur](Post-Processing-Motion-Blur.md)
    * [Panini Projection](Post-Processing-Panini-Projection.md)
    * [Shadows Midtones Highlights](Post-Processing-Shadows-Midtones-Highlights.md)
    * [Split Toning](Post-Processing-Split-Toning.md)
    * [Tonemapping](post-processing-tonemapping.md)
    * [Vignette](post-processing-vignette.md)
    * [White Balance](Post-Processing-White-Balance.md)
    * [Lens Flare](shared/lens-flare/lens-flare-component.md)

* [Shaders and Materials](shaders-in-universalrp.md)
  * [Shading Models](shading-model.md)
  * [Complex Lit](shader-complex-lit.md)
  * [Lit](lit-shader.md)
  * [Simple Lit](simple-lit-shader.md)
  * [Baked Lit](baked-lit-shader.md)
  * [Unlit](unlit-shader.md)
  * [Particles Lit](particles-lit-shader.md)
  * [Particles Simple Lit](particles-simple-lit-shader.md)
  * [Particles Unlit](particles-unlit-shader.md)
  * [Decal](decal-shader.md)
  * [Upgrading shaders from Built-in](upgrading-your-shaders.md)
  * [Shader stripping](shader-stripping.md)
  * [Writing custom shaders](writing-custom-shaders-urp.md)
    * [Creating a sample scene](writing-shaders-urp-basic-prerequisites.md)
    * [URP basic unlit shader](writing-shaders-urp-basic-unlit-structure.md)
    * [URP unlit shader with color input](writing-shaders-urp-unlit-color.md)
    * [Drawing a texture](writing-shaders-urp-unlit-texture.md)
    * [Visualizing normal vectors](writing-shaders-urp-unlit-normals.md)
    * [Reconstruct the world space positions](writing-shaders-urp-reconstruct-world-position.md)
  * [URP ShaderLab Pass tags](urp-shaders/urp-shaderlab-pass-tags.md)
* [How to](how-to.md)
  * [Blit in XR](renderer-features/how-to-fullscreen-blit-in-xr-spi.md)
  * [Use Render Objects Renderer Feature](renderer-features/how-to-custom-effect-render-objects.md)
  * [Create custom Renderer Feature](containers/create-custom-renderer-feature-1.md)
* [Customizing URP](customizing-urp.md)
  * [beginCameraRendering event](using-begincamerarendering.md)
  * [Create custom Renderer Feature](renderer-features/create-custom-renderer-feature.md)
* [Optimization](urp-optimization.md)
  * [Rendering Debugger](features/rendering-debugger.md)
* [2D graphic features](2d-index.md)
  * [Introduction to Lights 2D](Lights-2D-intro.md)
    * [Requirements and setup](Setup.md)
    * [Configuring the 2D Renderer Asset](2DRendererData_overview.md)
      * [HDR emulation scale](HDREmulationScale.md)
      * [Light Blend Styles](LightBlendStyles.md)
    * [Preparing and upgrading](PrepShader.md)
    * [Normal map and mask Textures](SecondaryTextures.md)
    * [Common Lights 2D properties](2DLightProperties.md)
      * [Lights 2D types and specific properties](LightTypes.md)
    * [2D Shadows](2DShadows.md)
    * [2D Renderer and Shader Graph](ShaderGraph.md)
  * [2D Pixel Perfect](2d-pixelperfect.md)
    * [Cinemachine Pixel Perfect extension](pixel-cinemachine.md)

* [Frequently asked questions (FAQ)](faq.md)
* [Known issues](known-issues.md)
