import java.io.*;
import java.util.*;
import java.util.concurrent.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.annotation.*;

@WebServlet(name="NetData",urlPatterns={"/NetData"})
public class NetData extends HttpServlet {
    ArrayBlockingQueue<Double> queue;
    public void doGet(HttpServletRequest request,
		      HttpServletResponse response)
	throws ServletException, IOException {
	request.setCharacterEncoding("utf-8");
	response.setContentType("text/plain; charset=utf-8");
	PrintWriter out= response.getWriter();

	if (queue == null) queue = new ArrayBlockingQueue<Double>(100);

	String data = request.getParameter("data"); // 入力データを受け取る
	if (data != null) {
	    Scanner sc = new Scanner(data);
	    while (sc.hasNext()) {
		double d = sc.nextDouble();
		queue.offer(d);
	    }
	    out.println(Integer.toString(queue.size()));
	    return;
	}

	// 20 以上データが溜まると、古いデータを捨てる
	while (queue.size() > 20) {
	    queue.poll();
	}

	// アップロードされたデータを空白で区切って返す
	StringBuilder sb = new StringBuilder();
	sb.append(queue.size()); sb.append(" ");
	while (queue.size() > 0) {
	    sb.append(queue.poll());
	    sb.append(" ");
	}
	out.println(sb.toString());
    }
}
