//
//  ViewController.swift
//  SwiftOpenCV
//
//  Created by Yoshihisa Nitta on 2016/06/17.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    var detector: ObjCWrapper!

    @IBOutlet weak var myImageView: UIImageView!
    
    @IBAction func tapButton(sender: AnyObject) {
        let image: UIImage? = UIImage(named: "lena.jpg")
        myImageView.image = image;
        if (detector.isActive()) {
            let arr = NSMutableArray()
            detector.detect(image,founds: arr)
            print(arr.count)
            
            UIGraphicsBeginImageContext(image!.size);
            image!.drawInRect(CGRectMake(0,0,image!.size.width,image!.size.height))
            let context: CGContextRef = UIGraphicsGetCurrentContext()!
            CGContextSetRGBStrokeColor(context, 1.0, 0.0, 0.0, 1.0)
            CGContextSetLineWidth(context, 5.0);
            for i in 0..<(arr.count/4) {
                let x:Int = arr[i * 4 + 0] as! NSNumber as Int
                let y:Int = arr[i * 4 + 1] as! NSNumber as Int
                let w:Int = arr[i * 4 + 2] as! NSNumber as Int
                let h:Int = arr[i * 4 + 3] as! NSNumber as Int
                print("\(i): \(x) \(y) \(w) \(h)")
                CGContextAddRect(context, CGRectMake(CGFloat(x),CGFloat(y),CGFloat(w),CGFloat(h)));
            }
            CGContextStrokePath(context)
            let img = UIGraphicsGetImageFromCurrentImageContext()
            UIGraphicsEndImageContext()
            
            myImageView.image = img;
         }
     }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        detector = ObjCWrapper();
        detector.setXML("haarcascade_frontalface_alt")
   }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

