//
//  AppDelegate.swift
//  SwiftLocalNotification
//
//  Created by Yoshihisa Nitta on 2016/07/11.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?
    var notifiedMessage: String?

    func application(application: UIApplication, didReceiveLocalNotification notification: UILocalNotification) {
        let vc: ViewController = self.window!.rootViewController as! ViewController
        vc.myLabel.text = notification.alertBody
        let alert: UIAlertController = UIAlertController(title:"Local Notify",
                                                       message: notification.alertBody,
                                                preferredStyle: UIAlertControllerStyle.Alert)
        alert.addAction(UIAlertAction(title:"Cancel",style:UIAlertActionStyle.Cancel,handler:nil))
        self.window!.rootViewController!.presentViewController(alert, animated: true, completion: nil)
    }
    
    func application(application: UIApplication, didFinishLaunchingWithOptions launchOptions: [NSObject: AnyObject]?) -> Bool {
        if let option = launchOptions {
            let notification = option[UIApplicationLaunchOptionsLocalNotificationKey] as! UILocalNotification?
            notifiedMessage = notification?.alertBody
        }
        return true
    }

    func applicationWillResignActive(application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(application: UIApplication) {
        // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }


}

