//
//  FileList.swift
//  SwiftFileViewer
//
//  Created by Yoshihisa Nitta on 2016/06/26.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class FileList: UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    var manager: NSFileManager!
    var path: String!
    var fullPath: String!
    var paths: Array<String>!

    @IBOutlet weak var myTableView: UITableView!
    
    @IBAction func tapBack(sender: AnyObject) {
        dismissViewControllerAnimated(true, completion: nil)
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section:Int) -> Int {
        if paths == nil {
            return 1
        }
        return paths.count;
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell: UITableViewCell = UITableViewCell(style: UITableViewCellStyle.Subtitle, reuseIdentifier: "Cell")
        cell.textLabel?.text = paths[indexPath.row]
        return cell
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        let storyboard = UIStoryboard(name:"Main",bundle:nil)
        let controller: FileSelect = storyboard.instantiateViewControllerWithIdentifier("FileSelect") as! FileSelect
        controller.path = paths[indexPath.row]
        self.presentViewController(controller, animated: true, completion: nil)
    }

    func refreshPaths() {
        paths = manager.subpathsAtPath(fullPath)
        print("fullPath = \(fullPath)")
        if paths != nil {
            print("paths.count = \(paths.count)")
        }
    }
    
    override func viewWillAppear(animated: Bool) {
        refreshPaths()
        self.myTableView.reloadData()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        myTableView.delegate = self
        myTableView.dataSource = self
        manager = NSFileManager.defaultManager()
        fullPath = NSHomeDirectory()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}
