//
//  ViewController.swift
//  SwiftAudioPlay
//
//  Created by Yoshihisa Nitta on 2016/07/01.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController {
    
    var players:[AVAudioPlayer]!
    let audioFiles = ["download4817","download4801","download4763","download4691","download4685" ]

    @IBAction func tapSound1(sender: AnyObject) {
        play(0)
    }
    @IBAction func tapSound2(sender: AnyObject) {
        play(1)
   }
    @IBAction func tapSound3(sender: AnyObject) {
        play(2)
    }
    @IBAction func tapSound4(sender: AnyObject) {
        play(3)
    }
    @IBAction func tapSound5(sender: AnyObject) {
        play(4)
    }
    
    func play(n:Int) {
        if n < players.count {
            players[n].play()
        }
    }
    
    func setup() {
        players = []
        for fname in audioFiles {
            let path = NSURL(fileURLWithPath: NSBundle.mainBundle().pathForResource(fname, ofType: "mp3")!)
            do {
                let player = try AVAudioPlayer(contentsOfURL:path)
                players.append(player)
            } catch let error as NSError {
                print("error has occurred: \(error)")
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setup()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

