//
//  ViewController.swift
//  SwiftAVFOpenCV
//
//  Created by Yoshihisa Nitta on 2016/06/18.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController, AVCaptureVideoDataOutputSampleBufferDelegate {
    
    var detector: ObjCWrapper!
    
    var mySession: AVCaptureSession!
    var myCamera: AVCaptureDevice!
    var myVideoInput: AVCaptureDeviceInput!
    var myVideoOutput: AVCaptureVideoDataOutput!
    var detectFlag: Bool = false
    
    @IBOutlet weak var myImageView: UIImageView!
    
    @IBAction func tapButton(sender: AnyObject) {
        mySession.startRunning()
    }
    
    @IBAction func tapStop(sender: AnyObject) {
        mySession.stopRunning()
    }
    
    @IBAction func tapDetect(sender: AnyObject) {
        detectFlag = !detectFlag
    }
    
    func captureOutput(captureOutput: AVCaptureOutput!, didOutputSampleBuffer sampleBuffer: CMSampleBuffer!, fromConnection connection: AVCaptureConnection!) {
        print("captureOutput:didOutputSampleBuffer:fromConnection)")
        if connection.supportsVideoOrientation {
            connection.videoOrientation = AVCaptureVideoOrientation.Portrait
        }
        dispatch_async(dispatch_get_main_queue(), {
            let image = self.imageFromSampleBuffer(sampleBuffer)
            if self.detectFlag {
                self.myImageView.image = self.detectFace(image)
            } else {
                self.myImageView.image = image
            }
        })
    }
    
    func imageFromSampleBuffer(sampleBuffer: CMSampleBufferRef) -> UIImage {
        let imageBuffer: CVImageBufferRef = CMSampleBufferGetImageBuffer(sampleBuffer)!
        CVPixelBufferLockBaseAddress(imageBuffer, 0)   // Lock Base Address
        let baseAddress = CVPixelBufferGetBaseAddressOfPlane(imageBuffer, 0)  // Get Original Image Information
        let bytesPerRow = CVPixelBufferGetBytesPerRow(imageBuffer)
        let width = CVPixelBufferGetWidth(imageBuffer)
        let height = CVPixelBufferGetHeight(imageBuffer)
        
        let colorSpace = CGColorSpaceCreateDeviceRGB()  // RGB ColorSpace
        let bitmapInfo = (CGBitmapInfo.ByteOrder32Little.rawValue | CGImageAlphaInfo.PremultipliedFirst.rawValue)
        let context = CGBitmapContextCreate(baseAddress, width, height, 8, bytesPerRow, colorSpace, bitmapInfo)
        let imageRef = CGBitmapContextCreateImage(context) // Create Quarts image
        
        CVPixelBufferUnlockBaseAddress(imageBuffer, 0)    // Unlock Base Address
        
        let resultImage: UIImage = UIImage(CGImage: imageRef!)
        
        return resultImage
    }
    
    func prepareVideo() {
        mySession = AVCaptureSession()
        mySession.sessionPreset = AVCaptureSessionPresetHigh
        let devices = AVCaptureDevice.devices()
        for device in devices {
            if (device.position == AVCaptureDevicePosition.Back) {
                myCamera = device as! AVCaptureDevice
            }
        }
        do {
            myVideoInput = try AVCaptureDeviceInput(device: myCamera)
            if (mySession.canAddInput(myVideoInput)) {
                mySession.addInput(myVideoInput)
            } else {
                print("cannot add input to session")
            }
            
            myVideoOutput = AVCaptureVideoDataOutput()
            myVideoOutput.videoSettings = [kCVPixelBufferPixelFormatTypeKey : Int(kCVPixelFormatType_32BGRA)]
            myVideoOutput.setSampleBufferDelegate(self,queue:dispatch_get_main_queue())
            myVideoOutput.alwaysDiscardsLateVideoFrames = true
            if (mySession.canAddOutput(myVideoOutput)) {
                 mySession.addOutput(myVideoOutput)
            } else {
                print("cannot add output to session")
            }
            
            /* // preview background
            let myVideoLayer = AVCaptureVideoPreviewLayer(session: mySession)
            myVideoLayer.frame = view.bounds
            myVideoLayer.videoGravity = AVLayerVideoGravityResizeAspectFill
            view.layer.insertSublayer(myVideoLayer,atIndex:0)
            */
        } catch let error as NSError {
            print("cannot use camera \(error)")
        }
    }
    
    func detectFace(image: UIImage) -> UIImage {
        if (detector.isActive()) {
            let arr = NSMutableArray()
            detector.detect(image,founds: arr)
            let count:Int = arr.count;
            print(count)
            
            UIGraphicsBeginImageContext(image.size);
            image.drawInRect(CGRectMake(0,0,image.size.width,image.size.height))
            let context: CGContextRef = UIGraphicsGetCurrentContext()!
            CGContextSetRGBStrokeColor(context, 1.0, 0.0, 0.0, 1.0)
            CGContextSetLineWidth(context, 5.0);
            for i in 0..<(count/4) {
                let x:Int = arr[i * 4 + 0] as! NSNumber as Int
                let y:Int = arr[i * 4 + 1] as! NSNumber as Int
                let w:Int = arr[i * 4 + 2] as! NSNumber as Int
                let h:Int = arr[i * 4 + 3] as! NSNumber as Int
                print("\(i): \(x) \(y) \(w) \(h)")
                CGContextAddRect(context, CGRectMake(CGFloat(x),CGFloat(y),CGFloat(w),CGFloat(h)));
            }
            CGContextStrokePath(context)
            let img = UIGraphicsGetImageFromCurrentImageContext()
            UIGraphicsEndImageContext()
            
            return img;
        }
        return image;
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        detector = ObjCWrapper();
        detector.setXML("haarcascade_frontalface_alt")
        prepareVideo()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

