//
//  ViewController.swift
//  SwiftAVFMovie
//
//  Created by Yoshihisa Nitta on 2016/06/23.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import AVFoundation
import AssetsLibrary

class ViewController: UIViewController,AVCaptureFileOutputRecordingDelegate {

    var session: AVCaptureSession!
    var videoDevice: AVCaptureDevice!
    var audioDevice: AVCaptureDevice!
    var videoInput: AVCaptureDeviceInput!
    var audioInput: AVCaptureDeviceInput!
    var fileOutput: AVCaptureMovieFileOutput!
    var filePath: String!
    
    var previewFlag: Bool = false;
    var previewLayer: AVCaptureVideoPreviewLayer!

    @IBOutlet weak var myLabel: UILabel!
    
    @IBAction func tapRecord(sender: AnyObject) {
        print("recording started")
        myLabel.text = "recording started"
        filePath = NSHomeDirectory() + "/Documents/test.mp4"
        let fileURL: NSURL = NSURL(fileURLWithPath: filePath)
       
        session.startRunning()
        fileOutput.startRecordingToOutputFileURL(fileURL, recordingDelegate: self)
    }
    @IBAction func tapStop(sender: AnyObject) {
        fileOutput.stopRecording()
        session.stopRunning()
        UISaveVideoAtPathToSavedPhotosAlbum(filePath, self, #selector(ViewController.video(_:didFinishSavingWithError:contextInfo:)), nil)
    }

    @IBAction func tapPreview(sender: AnyObject) {
        if previewFlag {
           previewLayer.removeFromSuperlayer()
        } else {
            view.layer.insertSublayer(previewLayer,atIndex:0)
        }
        previewFlag = !previewFlag
    }
    
    func captureOutput(captureOutput: AVCaptureFileOutput, didFinishRecordingToOutputFileAtURL outputFile: NSURL, fromConnections connections: [AnyObject]!,error: NSError) {
        print("recording finished")
        myLabel.text = "recording finished"
    }
    
    func video(videoPath: String, didFinishSavingWithError error: NSError!, contextInfo: UnsafeMutablePointer<Void>) {
        if (error != nil) {
            print("video saving fails")
            myLabel.text = "video saving fails"
        } else {
            print("video saving success")
            myLabel.text = "video saving success"
        }
    }
    
    func prepareVideo() {
        session = AVCaptureSession()
        session.sessionPreset = AVCaptureSessionPresetHigh
        let devices = AVCaptureDevice.devices()
        for device in devices {
            if (device.position == AVCaptureDevicePosition.Back) {
                videoDevice = device as! AVCaptureDevice
            }
        }
        audioDevice = AVCaptureDevice.defaultDeviceWithMediaType(AVMediaTypeAudio)
        do {
            videoInput = try AVCaptureDeviceInput(device: videoDevice)
            if (session.canAddInput(videoInput)) {
                session.addInput(videoInput)
            } else {
                print("cannot add video input to session")
            }
            audioInput = try AVCaptureDeviceInput(device: audioDevice)
            if (session.canAddInput(audioInput)) {
                session.addInput(audioInput)
            } else {
                print("cannot add audio input to session")
            }
            fileOutput = AVCaptureMovieFileOutput()
            if (session.canAddOutput(fileOutput)) {
                session.addOutput(fileOutput)
            } else {
                print("cannot add file output to session")
            }
            
            // preview background
             previewLayer = AVCaptureVideoPreviewLayer(session: session)!
            previewLayer.frame = view.bounds
            previewLayer.videoGravity = AVLayerVideoGravityResizeAspectFill
            
        } catch let error as NSError {
            print("cannot use camera \(error)")
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        prepareVideo()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


}

