﻿using UnityEngine;
using System.Collections;
using System;
using System.Runtime.InteropServices;

public class CubeBehaviour : MonoBehaviour {
    [DllImport ("NtKinectDll")] private static extern System.IntPtr getKinect();
    [DllImport ("NtKinectDll")] private static extern void initSpeech(System.IntPtr kinect);
    [DllImport ("NtKinectDll")] private static extern void setSpeechLang(IntPtr kinect,IntPtr lang,IntPtr grxml);
    [DllImport ("NtKinectDll")] private static extern int getSpeech(IntPtr kinect,ref IntPtr tagPtr,ref IntPtr itemPtr);
    [DllImport ("NtKinectDll")] private static extern void destroySpeech(IntPtr kinect);
    private IntPtr kinect;
    
    void Start () {
	kinect = getKinect();
	IntPtr lang = Marshal.StringToHGlobalUni("ja-JP"); // "en-US"
	IntPtr grxml = Marshal.StringToHGlobalUni("Grammar_jaJP.grxml"); // "Grammar_enUS.grxml"
	setSpeechLang(kinect,lang,grxml);
	initSpeech(kinect);
	Marshal.FreeHGlobal(lang);
	Marshal.FreeHGlobal(grxml);
    }
    
    void Update () {
	IntPtr tagPtr = (IntPtr)0;
	IntPtr itemPtr = (IntPtr)0;
	int flag = getSpeech(kinect,ref tagPtr,ref itemPtr);
	string speechTag = Marshal.PtrToStringUni(tagPtr);
	string speechItem = Marshal.PtrToStringUni(itemPtr);
	if (flag > 0) {
	    Debug.Log("tag = "+speechTag);
	    Debug.Log("item = "+speechItem);
	}
	if (flag>0 && speechTag.CompareTo("RED")==0) {
	    gameObject.GetComponent<Renderer>().material.color = new Color(1.0f, 0.0f, 0.0f, 1.0f);
	} else if (flag>0 && speechTag.CompareTo("GREEN")==0) {
	    gameObject.GetComponent<Renderer>().material.color = new Color(0.0f, 1.0f, 0.0f, 1.0f);
	} else if (flag>0 && speechTag.CompareTo("BLUE")==0) {
	    gameObject.GetComponent<Renderer>().material.color = new Color(0.0f, 0.0f, 1.0f, 1.0f);
	} else if (flag>0 && speechTag.CompareTo("EXIT")==0) {
	    Application.Quit();
	    UnityEditor.EditorApplication.isPlaying = false;
	}
    }
    void OnApplicationQuit() {
	destroySpeech(kinect);
    }
}
