#ifdef NTKINECTDLL_EXPORTS
#define NTKINECTDLL_API __declspec(dllexport)
#else
#define NTKINECTDLL_API __declspec(dllimport)
#endif

#include <mutex>
#include <list>
#include <thread>

namespace NtKinectSpeech {
  extern "C" {
    NTKINECTDLL_API void* getKinect(void);
    NTKINECTDLL_API void initSpeech(void* kinect);
    NTKINECTDLL_API void setSpeechLang(void* kinect,wchar_t*,wchar_t*);
    NTKINECTDLL_API int speechQueueSize(void* kinect);
    NTKINECTDLL_API int getSpeech(void* kinect,wchar_t*& tagPtr,wchar_t*& itemPtr);
    NTKINECTDLL_API void destroySpeech(void* kinect);
  }
  std::mutex mutex;
  std::thread* speechThread;
  std::list<std::pair<std::wstring,std::wstring>> speechQueue;
  bool speechActive;
#define SPEECH_MAX_LENGTH	1024
  wchar_t tagBuffer[SPEECH_MAX_LENGTH];
  wchar_t itemBuffer[SPEECH_MAX_LENGTH];
}
