#include "stdafx.h"
#include "NtKinectDll.h"

#include "NtKinect.h"

using namespace std;

NTKINECTDLL_API void* getKinect(void) {
  NtKinect* kinect = new NtKinect;
  return static_cast<void*>(kinect);
}

NTKINECTDLL_API int setSkeleton(void* ptr, float *skeleton, int* state, int* id) {
  NtKinect *kinect = static_cast<NtKinect*>(ptr);
  (*kinect).setRGB();
  (*kinect).setSkeleton();
  int scale = 4;
  cv::Mat img((*kinect).rgbImage);
  cv::resize(img,img,cv::Size(img.cols/scale,img.rows/scale),0,0);
  for (auto& person: (*kinect).skeleton) {
    for (auto& joint: person) {
      if (joint.TrackingState == TrackingState_NotTracked) continue;
      ColorSpacePoint cp;
      (*kinect).coordinateMapper->MapCameraPointToColorSpace(joint.Position,&cp);
      cv::rectangle(img, cv::Rect((int)cp.X/scale-2, (int)cp.Y/scale-2,4,4), cv::Scalar(0,0,255),2);
    }
  }
  cv::imshow("skeleton",img);
  cv::waitKey(1);
  int idx=0, jt=0, st=0;
  for (auto& person: (*kinect).skeleton) {
    for (auto& joint: person) {
      skeleton[jt++] = joint.Position.X;
      skeleton[jt++] = joint.Position.Y;
      skeleton[jt++] = joint.Position.Z;
      state[st++] = joint.TrackingState;
    }
    id[idx] = (*kinect).skeletonId[idx];
    idx++;
  }
  return idx;
}
