#include "stdafx.h"
#include <unordered_map>
#include "NtKinectDll.h"

#define USE_GESTURE
#include "NtKinect.h"

using namespace std;

namespace NtKinectGesture {
  NTKINECTDLL_API void* getKinect(void) {
    NtKinect* kinect = new NtKinect;
    return static_cast<void*>(kinect);
  }

  NTKINECTDLL_API int rightHandState(void* ptr) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    (*kinect).setRGB();
    (*kinect).setSkeleton();
    int scale = 4;
    cv::Mat img((*kinect).rgbImage);
    cv::resize(img,img,cv::Size(img.cols/scale,img.rows/scale),0,0);
    for (auto person: (*kinect).skeleton) {
      for (auto joint: person) {
	if (joint.TrackingState == TrackingState_NotTracked) continue;
	ColorSpacePoint cp;
	(*kinect).coordinateMapper->MapCameraPointToColorSpace(joint.Position,&cp);
	cv::rectangle(img, cv::Rect((int)cp.X/scale-2, (int)cp.Y/scale-2,4,4), cv::Scalar(0,0,255),2);
      }
    }
    cv::imshow("rgb",img);
    cv::waitKey(1);
    for (int i=0; i<(*kinect).skeleton.size(); i++) {
      Joint right = (*kinect).skeleton[i][JointType_HandRight];
      if (right.TrackingState == TrackingState_NotTracked) continue;
      auto state = (*kinect).handState(i,false);
      if (state.first == HandState_Open
	  || state.first == HandState_Closed
	  || state.first == HandState_Lasso ) {
	return state.first;
      }
    }
    return HandState_Unknown;
  }

  NTKINECTDLL_API void setGestureFile(void* ptr, wchar_t* filename) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    wstring fname(filename);
    (*kinect).setGestureFile(fname);
  }

  NTKINECTDLL_API int setGestureId(void* ptr, wchar_t* name, int id) {
    int len = WideCharToMultiByte(CP_UTF8,NULL,name,-1,NULL,0,NULL,NULL) + 1;
    char* nameBuffer = new char[len];
    memset(nameBuffer,'\0',len);
    WideCharToMultiByte(CP_UTF8,NULL,name,-1,nameBuffer,len,NULL,NULL);
    string s(nameBuffer);
    gidMap[s] = id;

    return id;
  }

  NTKINECTDLL_API void setGesture(void* ptr) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    (*kinect).setRGB();
    (*kinect).setSkeleton();
    int scale = 4;
    cv::Mat img((*kinect).rgbImage);
    cv::resize(img,img,cv::Size(img.cols/scale,img.rows/scale),0,0);
    for (auto person: (*kinect).skeleton) {
      for (auto joint: person) {
	if (joint.TrackingState == TrackingState_NotTracked) continue;
	ColorSpacePoint cp;
	(*kinect).coordinateMapper->MapCameraPointToColorSpace(joint.Position,&cp);
	cv::rectangle(img, cv::Rect((int)cp.X/scale-2, (int)cp.Y/scale-2,4,4), cv::Scalar(0,0,255),2);
      }
    }
    cv::imshow("rgb",img);
    cv::waitKey(1);
    (*kinect).setGesture();
  }

  NTKINECTDLL_API int getDiscreteGesture(void* ptr, int *gid, float *confidence) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    for (int i=0; i<(*kinect).discreteGesture.size(); i++) {
      auto g = (*kinect).discreteGesture[i];
      string gname = (*kinect).gesture2string(g.first);
      gid[i] = gidMap[gname];
      confidence[i] = g.second;
    }
    return (*kinect).discreteGesture.size();
  }

  NTKINECTDLL_API int getContinuousGesture(void* ptr, int *gid, float *progress){
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    for (int i=0; i<(*kinect).continuousGesture.size(); i++) {
      auto g = (*kinect).continuousGesture[i];
      string gname = (*kinect).gesture2string(g.first);
      gid[i] = gidMap[gname];
      progress[i] = g.second;
    }
    return (*kinect).continuousGesture.size();
  }

  NTKINECTDLL_API void stopKinect(void* ptr) {
    cv::destroyAllWindows();
  }
}
