#include "stdafx.h"
#include "NtKinectDll.h"

#define USE_THREAD
#define USE_SPEECH
#include "NtKinect.h"

using namespace std;

namespace NtKinectSpeech {
  NTKINECTDLL_API void* getKinect(void) {
    NtKinect* kinect = new NtKinect;
    return static_cast<void*>(kinect);
  }

  NTKINECTDLL_API void setSpeechLang(void* ptr, wchar_t* wlang, wchar_t* grxmlBuffer) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    if (wlang && grxmlBuffer) {
      int len = WideCharToMultiByte(CP_UTF8,NULL,wlang,-1,NULL,0,NULL,NULL) + 1;
      char* langBuffer = new char[len];
      memset(langBuffer,'\0',len);
      WideCharToMultiByte(CP_UTF8,NULL,wlang,-1,langBuffer,len,NULL,NULL);
      string lang(langBuffer);
      wstring grxml(grxmlBuffer);
      (*kinect).acquire();
      (*kinect).setSpeechLang(lang,grxml);
      (*kinect).release();
    }
  }

  void speechThreadFunc(NtKinect* kinect) {
    ERROR_CHECK(CoInitializeEx(NULL,COINIT_MULTITHREADED));
    (*kinect).acquire();
    (*kinect).startSpeech();
    (*kinect).release();
    while (speechActive) {
      pair<wstring,wstring> p;
      bool flag = (*kinect)._setSpeech(p);
      if (flag) {
        mutex.lock();
        speechQueue.push_back(p);
        mutex.unlock();
      }
      std::this_thread::sleep_for(std::chrono::milliseconds(10));
    }
  }
  
  NTKINECTDLL_API void initSpeech(void* ptr) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    speechActive = true;
    speechThread = new std::thread(NtKinectSpeech::speechThreadFunc, kinect);
    return;
  }
  
  NTKINECTDLL_API int speechQueueSize(void* ptr) {
    int n=0;
    mutex.lock();
    n = (int) speechQueue.size();
    mutex.unlock();
    return n;
  }
  
  NTKINECTDLL_API int getSpeech(void* ptr, wchar_t*& tagPtr, wchar_t*& itemPtr) {
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    wmemset(tagBuffer,'\0',SPEECH_MAX_LENGTH);
    wmemset(itemBuffer,'\0',SPEECH_MAX_LENGTH);
    pair<wstring,wstring> p;
    mutex.lock();
    bool empty = speechQueue.empty();
    if (! empty) {
      p = speechQueue.front();
      speechQueue.pop_front();
    }
    mutex.unlock();
    if (!empty) {
      wsprintf(tagBuffer,L"%ls",p.first);
      wsprintf(itemBuffer,L"%ls",p.second);
    }
    tagPtr = tagBuffer;
    itemPtr = itemBuffer;
    return !empty;
  }
  
  NTKINECTDLL_API void destroySpeech(void* ptr) {
    speechActive = false;
    speechThread->join();
    NtKinect *kinect = static_cast<NtKinect*>(ptr);
    (*kinect).acquire();
    (*kinect).stopSpeech();
    (*kinect).release();
    delete speechThread;
    CoUninitialize();
  }
}
