#include <iostream>
#include <sstream>

#define USE_THREAD
#include "NtKinect.h"

using namespace std;

NtKinect kinect;

unsigned __stdcall doJob1(LPVOID pParam) {
  cv::Mat image;
  vector<vector<Joint> > skel;
  vector<int> skelId;
  vector<UINT64> skelTrackingId;
  while (1) {
    kinect._setRGB(image);
    kinect._setSkeleton(skel,skelId,skelTrackingId);
    for (auto person: skel) {
      for (auto joint: person) {
	if (joint.TrackingState == TrackingState_NotTracked) continue;
	ColorSpacePoint cp;
	kinect._MapCameraPointToColorSpace(joint.Position,&cp);
	cv::rectangle(image,cv::Rect((int)cp.X-5,(int)cp.Y-5,10,10),cv::Scalar(0,0,255),2);
      }
    }
    cv::imshow("1", image);
    auto key = cv::waitKey(1);
    if (key == 'q') break;
  }
  cv::destroyWindow("1");
  _endthreadex(0);
  return 0;
}

void drawHand(cv::Mat& image, Joint& joint, pair<int,int>& state) {
  cv::Scalar colors[] = {
    cv::Scalar(255,0,0),  // HandState_Unknown
    cv::Scalar(0,255,0),  // HandState_NotTracked
    cv::Scalar(255,255,0), // HandState_Open
    cv::Scalar(255,0,255), // HandState_Closed
    cv::Scalar(0,255,255),  // HandState_Lass
  };
  ColorSpacePoint cp;
  kinect._MapCameraPointToColorSpace(joint.Position,&cp);
  cv::rectangle(image, cv::Rect((int)cp.X-8, (int)cp.Y-8, 16, 16), colors[state.first], 4);
}

unsigned __stdcall doJob2(LPVOID pParam) {
  cv::Mat image;
  vector<vector<Joint> > skel;
  vector<int> skelId;
  vector<UINT64> skelTrackingId;
  while (1) {
    kinect._setRGB(image);
    kinect._setSkeleton(skel,skelId,skelTrackingId);
    for (int i=0; i<skel.size(); i++) {
      Joint left = skel[i][JointType_HandLeft];
      Joint right = skel[i][JointType_HandRight];
      if (left.TrackingState != TrackingState_NotTracked) {
	auto state = kinect._handState(i,true);
	drawHand(image,left,state);
      }
      if (right.TrackingState != TrackingState_NotTracked) {
	auto state = kinect._handState(i,false);
	drawHand(image,right,state);
      }
    }
    cv::imshow("2", image);
    auto key = cv::waitKey(1);
    if (key == 'q') break;
  }
  cv::destroyWindow("2");
  _endthreadex(0);
  return 0;
}

unsigned __stdcall doJob3(LPVOID pParam) {
  cv::Mat image;
  while (1) {
    kinect._setBodyIndex(image,false);
    cv::imshow("3", image);
    auto key = cv::waitKey(1);
    if (key == 'q') break;
  }
  cv::destroyWindow("3");
  _endthreadex(0);
  return 0;
}

void doJob() {
  HANDLE hThread[3] = { 0 };
  hThread[0] = (HANDLE) _beginthreadex(NULL,0,doJob1,NULL,0,NULL);
  if (hThread[0] == 0) throw runtime_error("cannot create thread 0");
  hThread[1] = (HANDLE) _beginthreadex(NULL,0,doJob2,NULL,0,NULL);
  if (hThread[1] == 0) throw runtime_error("cannot create thread 1");
  hThread[2] = (HANDLE) _beginthreadex(NULL,0,doJob3,NULL,0,NULL);
  if (hThread[2] == 0) throw runtime_error("cannot create thread 2");
  DWORD ret = WaitForMultipleObjects(3,hThread,TRUE,INFINITE);
  if (ret == WAIT_FAILED) throw runtime_error("wait failed");
}

int main(int argc, char** argv) {
  try {
    doJob();
  } catch (exception &ex) {
    cout << ex.what() << endl;
    string s;
    cin >> s;
  }
  return 0;
}
