#include <iostream>
#include <sstream>

#define USE_SPEECH
#define USE_THREAD
#include "NtKinect.h"

using namespace std;

NtKinect kinect;

unsigned __stdcall doJob1(LPVOID pParam) {
  cv::Mat image;
  vector<vector<Joint> > skel;
  vector<int> skelId;
  vector<UINT64> skelTrackingId;
  while (1) {
    kinect._setRGB(image);
    kinect._setSkeleton(skel,skelId,skelTrackingId);
    for (auto person: skel) {
      for (auto joint: person) {
	if (joint.TrackingState == TrackingState_NotTracked) continue;
	ColorSpacePoint cp;
	kinect._MapCameraPointToColorSpace(joint.Position,&cp);
	cv::rectangle(image,cv::Rect((int)cp.X-5,(int)cp.Y-5,10,10),cv::Scalar(0,0,255),2);
      }
    }
    cv::imshow("1", image);
    auto key = cv::waitKey(1);
    if (key == 'q') break;
  }
  cv::destroyWindow("1");
  _endthreadex(0);
  return 0;
}

unsigned __stdcall doJob2(LPVOID pParam) {
  cv::Mat image;
  while (1) {
    kinect._setBodyIndex(image,false);
    cv::imshow("2", image);
    auto key = cv::waitKey(1);
    if (key == 'q') break;
  }
  cv::destroyWindow("2");
  _endthreadex(0);
  return 0;
}

unsigned __stdcall doJob3(LPVOID pParam) {
  ERROR_CHECK(CoInitializeEx(NULL, COINIT_MULTITHREADED));
  kinect.acquire();
  kinect.startSpeech();
  kinect.release();
  std::wcout.imbue(std::locale(""));
  
  pair<wstring,wstring> p;
  while (1) {
    bool ret = kinect._setSpeech(p);
    if (ret) {
      wcout << p.first << L" " << p.second << endl;
    }
    if (p.first == L"EXIT") break;
    //Sleep(1L);
  }
  kinect.acquire();
  kinect.stopSpeech();
  kinect.release();
  _endthreadex(0);
  return 0;
}

void doJob() {
  HANDLE hThread[3] = { 0 };
  hThread[0] = (HANDLE) _beginthreadex(NULL,0,doJob1,NULL,0,NULL);
  if (hThread[0] == 0) throw runtime_error("cannot create thread 0");
  hThread[1] = (HANDLE) _beginthreadex(NULL,0,doJob2,NULL,0,NULL);
  if (hThread[1] == 0) throw runtime_error("cannot create thread 1");
  hThread[2] = (HANDLE) _beginthreadex(NULL,0,doJob3,NULL,0,NULL);
  if (hThread[2] == 0) throw runtime_error("cannot create thread 2");
  DWORD ret = WaitForMultipleObjects(3,hThread,TRUE,INFINITE);
  if (ret == WAIT_FAILED) throw runtime_error("wait failed");
}

int main(int argc, char** argv) {
  try {
    doJob();
  } catch (exception &ex) {
    cout << ex.what() << endl;
    string s;
    cin >> s;
  }
  return 0;
}
