﻿/*
 * Copyright (c) 2017 Yoshihisa Nitta
 * Released under the MIT license
 * http://opensource.org/licenses/mit-license.php
 */

/* http://nw.tsuda.ac.jp/lec/unity5/ */
/* version 1.1: 2017/08/10 */
/* version 1.0: 2017/08/06 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Runtime.InteropServices;

public class RigControl2 : MonoBehaviour {
  [DllImport ("NtKinectDll")] private static extern System.IntPtr getKinect();
  [DllImport ("NtKinectDll")] private static extern int setSkeleton(System.IntPtr kinect, System.IntPtr data, System.IntPtr state, System.IntPtr id);
  int bodyCount = 6;
  int jointCount = 25;
  private System.IntPtr kinect;

  public GameObject[] humanoid = new GameObject[] {null, null, null, null, null, null};
  public bool[] mirror = new bool[] {true, true, true, true, true, true};
  public bool[] move = new bool[] {true, true, true, true, true, true};
  CharacterSkeleton[] skeleton = new CharacterSkeleton[] {null, null, null, null, null, null};

  void Start () {
    kinect = getKinect();
    for (int i=0; i<bodyCount; i++) {
      if (humanoid[i] != null) {
	skeleton[i] = new CharacterSkeleton(humanoid[i]);
      }
    }
  }
  void Update () {
    float[] data = new float[bodyCount * jointCount * 3];
    int[] state = new int[bodyCount * jointCount];
    int[] id = new int[bodyCount];
    GCHandle gch = GCHandle.Alloc(data,GCHandleType.Pinned);
    GCHandle gch2 = GCHandle.Alloc(state,GCHandleType.Pinned);
    GCHandle gch3 = GCHandle.Alloc(id,GCHandleType.Pinned);
    int n = setSkeleton(kinect,gch.AddrOfPinnedObject(),gch2.AddrOfPinnedObject(),gch3.AddrOfPinnedObject());
    gch.Free();
    gch2.Free();
    gch3.Free();
    for (int i=0; i<bodyCount; i++) {
      if (i < n && skeleton[i] != null) {
	skeleton[i].set(data,state,i,mirror[i],move[i]);
      } else {
	humanoid[i].transform.position = new Vector3(0,0,-10);
      }
    }
  }
}
