﻿using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;
using System;

public class NtKinectGesture : MonoBehaviour {
  [DllImport ("NtKinectDll")] private static extern System.IntPtr getKinect();
  [DllImport ("NtKinectDll")] private static extern int rightHandState(System.IntPtr kinect);
  [DllImport ("NtKinectDll")] private static extern void setGestureFile(System.IntPtr ptr, System.IntPtr filename);
  [DllImport ("NtKinectDll")] private static extern int setGestureId(System.IntPtr ptr, System.IntPtr filename, int id);
  [DllImport ("NtKinectDll")] private static extern void setGesture(System.IntPtr kinect);
  [DllImport ("NtKinectDll")] private static extern int getDiscreteGesture(System.IntPtr kinect, System.IntPtr gid, System.IntPtr cnf);
  [DllImport ("NtKinectDll")] private static extern int getContinuousGesture(System.IntPtr kinect, System.IntPtr gid, System.IntPtr cnf);
  [DllImport ("NtKinectDll")] private static extern void stopKinect(System.IntPtr kinect);

  private System.IntPtr kinect;
  int gestureCount = 18;
 
  void Start () {
    kinect = getKinect();
    setGestureFile(kinect,Marshal.StringToHGlobalUni("SampleDatabase.gbd"));
    setGestureId(kinect,Marshal.StringToHGlobalUni("Steer_Left"),1); // discrete
    setGestureId(kinect,Marshal.StringToHGlobalUni("Steer_Rifht"),2); // discrete
    setGestureId(kinect,Marshal.StringToHGlobalUni("SteerProgress"),3); // continuous
    setGestureId(kinect,Marshal.StringToHGlobalUni("SteerStraight"),4); // discrete
  }
  void Update () {
    setGesture(kinect);
    int[] gid = new int[gestureCount];
    float[] cnf = new float[gestureCount];
    GCHandle gch = GCHandle.Alloc(gid,GCHandleType.Pinned);
    GCHandle gch2 = GCHandle.Alloc(cnf,GCHandleType.Pinned);
    // discrete gesture
    int n = getDiscreteGesture(kinect, gch.AddrOfPinnedObject(), gch2.AddrOfPinnedObject());
    for (int i=0; i<n; i++) {
      Debug.Log(i + " discrete " + gid[i] + " " + cnf[i]); // "cnf" value is "confidence"
    }
    // continous gesture
    n = getContinuousGesture(kinect, gch.AddrOfPinnedObject(), gch2.AddrOfPinnedObject());
    for (int i=0; i<n; i++) {
      Debug.Log(i + " continous " + gid[i] + " " + cnf[i]); // "cnf" value is "progress"
    }
    gch.Free();
    gch2.Free();
  }
  void OnApplicationQuit() {
    stopKinect(kinect);
  }
}
