﻿using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

public class NtKinectBehaviour : MonoBehaviour {
    [DllImport ("NtKinectDll")] private static extern System.IntPtr getKinect();
    [DllImport ("NtKinectDll")] private static extern int rightHandState(System.IntPtr kinect);
    [DllImport ("NtKinectDll")] private static extern int faceDirection(System.IntPtr kinect, System.IntPtr data);

    int bodyCount = 6;
    private System.IntPtr kinect;
    GameObject[] obj;
    int counter;
    
    void Start () {
        kinect = getKinect();
	obj = new GameObject[bodyCount];
	obj[0] = GameObject.Find("Cube0");
	obj[1] = GameObject.Find("Cube1");
	obj[2] = GameObject.Find("Cube2");
	obj[3] = GameObject.Find("Cube3");
	obj[4] = GameObject.Find("Cube4");
	obj[5] = GameObject.Find("Cube5");
    }
    public static Quaternion ToQ (float pitch, float yaw, float roll) {
	yaw *= Mathf.Deg2Rad;
	pitch *= Mathf.Deg2Rad;
	roll *= Mathf.Deg2Rad;
	float rollOver2 = roll * 0.5f;
	float sinRollOver2 = (float)System.Math.Sin ((double)rollOver2);
	float cosRollOver2 = (float)System.Math.Cos ((double)rollOver2);
	float pitchOver2 = pitch * 0.5f;
	float sinPitchOver2 = (float)System.Math.Sin ((double)pitchOver2);
	float cosPitchOver2 = (float)System.Math.Cos ((double)pitchOver2);
	float yawOver2 = yaw * 0.5f;
	float sinYawOver2 = (float)System.Math.Sin ((double)yawOver2);
	float cosYawOver2 = (float)System.Math.Cos ((double)yawOver2);
	Quaternion result;
	result.w = cosYawOver2 * cosPitchOver2 * cosRollOver2 + sinYawOver2 * sinPitchOver2 * sinRollOver2;
	result.x = cosYawOver2 * sinPitchOver2 * cosRollOver2 + sinYawOver2 * cosPitchOver2 * sinRollOver2;
	result.y = sinYawOver2 * cosPitchOver2 * cosRollOver2 - cosYawOver2 * sinPitchOver2 * sinRollOver2;
	result.z = cosYawOver2 * cosPitchOver2 * sinRollOver2 - sinYawOver2 * sinPitchOver2 * cosRollOver2;
	return result;
    }

    void Update () {
	float[] data = new float[bodyCount * 3];
	GCHandle gch = GCHandle.Alloc(data,GCHandleType.Pinned);
	int n = faceDirection(kinect,gch.AddrOfPinnedObject());
	gch.Free();
	counter = (n != 0) ? 10 : System.Math.Max(0,counter-1);
	for (int i=0; i<bodyCount; i++) {
	    if (i<n) {
		obj[i].transform.rotation = ToQ(data[i*3+0],data[i*3+1],data[i*3+2]);
		obj[i].GetComponent<Renderer>().material.color = new Color(1.0f,0.0f,0.0f,1.0f);
	    } else if (counter == 0) {
		obj[i].transform.rotation = Quaternion.identity;
		obj[i].GetComponent<Renderer>().material.color = new Color(1.0f,1.0f,1.0f,1.0f);
	    }
	}
    }
}
