﻿using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;
using System;

public class NtKinectGesture : MonoBehaviour {
  [DllImport ("NtKinectDll")] private static extern System.IntPtr getKinect();
  [DllImport ("NtKinectDll")] private static extern int rightHandState(System.IntPtr kinect);
  [DllImport ("NtKinectDll")] private static extern void setGestureFile(System.IntPtr ptr, System.IntPtr filename);
  [DllImport ("NtKinectDll")] private static extern int setGestureId(System.IntPtr ptr, System.IntPtr name, int id);
  [DllImport ("NtKinectDll")] private static extern void setGesture(System.IntPtr kinect);
  [DllImport ("NtKinectDll")] private static extern int getDiscreteGesture(System.IntPtr kinect, System.IntPtr gid, System.IntPtr cnf);
  [DllImport ("NtKinectDll")] private static extern int getContinuousGesture(System.IntPtr kinect, System.IntPtr gid, System.IntPtr cnf);
  [DllImport ("NtKinectDll")] private static extern void stopKinect(System.IntPtr kinect);

  private System.IntPtr kinect;
  int gestureCount = 18;
 
  void Start () {
    kinect = getKinect();
    System.IntPtr gbd = Marshal.StringToHGlobalUni("SampleDatabase.gbd"); // gbd file
    System.IntPtr g1 = Marshal.StringToHGlobalUni("Steer_Left"); // discrete
    System.IntPtr g2 = Marshal.StringToHGlobalUni("Steer_Right"); // discrete
    System.IntPtr g3 = Marshal.StringToHGlobalUni("SteerProgress"); // continuous
    System.IntPtr g4 = Marshal.StringToHGlobalUni("SteerStraight"); // discrete
    setGestureFile(kinect,gbd);
    setGestureId(kinect,g1,1);
    setGestureId(kinect,g2,2);
    setGestureId(kinect,g3,3);
    setGestureId(kinect,g4,4);
    Marshal.FreeHGlobal(gbd);
    Marshal.FreeHGlobal(g1);
    Marshal.FreeHGlobal(g2);
    Marshal.FreeHGlobal(g3);
    Marshal.FreeHGlobal(g4);
  }
  void Update () {
    setGesture(kinect);
    int[] gid = new int[gestureCount];
    float[] cnf = new float[gestureCount];
    GCHandle gch = GCHandle.Alloc(gid,GCHandleType.Pinned);
    GCHandle gch2 = GCHandle.Alloc(cnf,GCHandleType.Pinned);
    // discrete gesture
    int n = getDiscreteGesture(kinect, gch.AddrOfPinnedObject(), gch2.AddrOfPinnedObject());
    for (int i=0; i<n; i++) {
      Debug.Log(i + " discrete " + gid[i] + " " + cnf[i]); // "cnf" value is "confidence"
    }
    // continous gesture
    n = getContinuousGesture(kinect, gch.AddrOfPinnedObject(), gch2.AddrOfPinnedObject());
    for (int i=0; i<n; i++) {
      Debug.Log(i + " continous " + gid[i] + " " + cnf[i]); // "cnf" value is "progress"
    }
    gch.Free();
    gch2.Free();
  }
  void OnApplicationQuit() {
    stopKinect(kinect);
  }
}
