#include <iostream>
#include <sstream>
#define _USE_MATH_DEFINES
#include <math.h>

#include <opencv2/opencv.hpp>

using namespace std;

void draw(cv::Mat& img, const vector<double>& v, int start = 0, int n = 1024) {
  stringstream ss;
  if (start < 0) start = v.size() + start;
  if (start < 0) start = 0;
  if (start >= v.size()) return;
  int end = start + n;
  if (end > v.size()) end = v.size();
  int m = end - start; // real data number
  if (m <= 0) return;
  int padding = 30;
  double wstep = ((double) img.cols - 2 * padding) / n;
  auto Dmin = *min_element(v.begin()+start,v.begin()+end);
  auto Dmax = *max_element(v.begin()+start,v.begin()+end);
  if (Dmin == Dmax) Dmax = Dmin + 1;
  cv::rectangle(img,cv::Rect(0,0,img.cols,img.rows),cv::Scalar(255,255,255),-1);
  for (int i=0; i<m; i++) {
    int x = (int) (padding + i * wstep);
    int y = (int) (padding + (img.rows - 2 * padding) * (v[start+i] - Dmin) / (Dmax-Dmin));
    y = img.rows - 1 - y;
    cv::rectangle(img,cv::Rect(x-2,y-2,4,4),cv::Scalar(255,0,0),-1);
  }
  ss.str(""); ss << (int)Dmin;
  cv::putText(img,ss.str(),cv::Point(0,img.rows-padding),cv::FONT_HERSHEY_SIMPLEX,0.4,cv::Scalar(0,0,0),1,CV_AA);
  ss.str(""); ss << (int)Dmax;
  cv::putText(img,ss.str(),cv::Point(0,padding),cv::FONT_HERSHEY_SIMPLEX,0.4,cv::Scalar(0,0,0),1,CV_AA);
}

void DFT(vector<double>& data,vector<double>&ret,int start, int n) {
  if (start < 0) start = data.size() + start;
  if (start < 0) start = 0;
  if (start >= data.size()) start = data.size();
  if (start + n > data.size()) n = data.size() - start;
  ret.resize(n);
  if (n <= 0) return;
  vector<double> re(n), im(n);
  for (int i=0; i<n; i++) {
    re[i] = 0.0;
    im[i] = 0.0;
    double d = 2 * M_PI * i / n;
    for (int j=0; j<n; j++) {
      re[i] += data[start+j] * cos(d * j);
      im[i] -= data[start+j] * sin(d * j);
    }
  }
  for (int i=0; i<n; i++) ret[i] = sqrt(re[i]*re[i] + im[i]*im[i]);
}

void drawMsg(cv::Mat& img, vector<double>& ret) {
  stringstream ss;
  int y = 100;
  for (int i=1; i<ret.size()/2 -1; i++) {
    if (ret[i] > ret[i-1] && ret[i] > ret[i+1]) {
      ss.str("");
      ss << "result[" << i << "]=" << ret[i] << " ";
      cv::putText(img,ss.str(),cv::Point(100,y),cv::FONT_HERSHEY_SIMPLEX,1.0,cv::Scalar(0,0,0),2,CV_AA);
      y += 40;
    }
  }
}

void doJob() {
  cv::Mat img(480,1280,CV_8UC3);
  cv::Mat dftImg(480,1280,CV_8UC3);
  vector<double> data(1024), ret;
  for (int i=0; i<=data.size(); i++) {
    data[i] = 0.2 * sin(2 * M_PI * (i / 32.0 + 0.2)) 
      + 0.5 * sin(2 * M_PI * (i / 120.0 + 0.7))
      + 1.0 * sin(2 * M_PI * (i / 200.0 + 0.5));
  }

  draw(img,data,0,data.size());
  cv::imshow("wave",img);

  DFT(data,ret,0,1024);
  draw(dftImg,ret,0,ret.size());
  drawMsg(dftImg,ret);
  cv::imshow("dft",dftImg);
    
  auto key = cv::waitKey(0);
  cv::destroyAllWindows();
}

int main(int argc, char** argv) {
  try {
    doJob();
  }
  catch (exception &ex) {
    cout << ex.what() << endl;
    string s;
    cin >> s;
  }
  return 0;
}

