﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Sample02b : MonoBehaviour {
  public GameObject[] humanoid = new GameObject[] {null, null, null, null, null, null};
  public bool[] mirror = new bool[] {true, true, true, true, true, true};
  public bool[] move = new bool[] {true, true, true, true, true, true};

  NtUnity.Kinect nt;
  NtUnity.HumanoidSkeleton[] hs = new NtUnity.HumanoidSkeleton[] {null, null, null, null, null, null};
  
  void Start () {
    nt = new NtUnity.Kinect();
    for (int i=0; i< humanoid.Length; i++) {
      if (humanoid[i] != null) {
	hs[i] = new NtUnity.HumanoidSkeleton(humanoid[i]);
      }
    }
  }

  void Update () {
    nt.setRGB();
    nt.setSkeleton();
    nt.setFace();
    nt.imshowBlack();
    for (int i=0; i<nt.skeleton.Count; i++) {
      if (hs[i] != null) {
	hs[i].set(nt,i,mirror[i],move[i]);
      } else {
	humanoid[i].transform.position = new Vector3(0,0,-10);
      }
    }
  }

  void OnApplicationQuit() {
    nt.stopKinect();
  }
}
