/*
 * Copyright (c) 2017 Yoshihisa Nitta
 * Released under the MIT license
 * http://opensource.org/licenses/mit-license.php
 */

/*
 * NtKinectDLL.h version 1.0: 2017/08/19
 * http://nw.tsuda.ac.jp/lec/kinect2/NtKinectDLL
 *
 * requires:
 *    NtKinect version 1.8.2 and after
 */

#ifdef NTKINECTDLL_EXPORTS
#define NTKINECTDLL_API __declspec(dllexport)
#else
#define NTKINECTDLL_API __declspec(dllimport)
#endif

namespace NtKinectDLL {
  extern "C" {
    NTKINECTDLL_API void* getKinect(void);
    NTKINECTDLL_API void stopKinect(void* ptr);

    // OpenCV
    NTKINECTDLL_API void imshow(void* ptr);

    // Multi Thread
    NTKINECTDLL_API void acquire(void* ptr);
    NTKINECTDLL_API void release(void* ptr);

    // Audio
    NTKINECTDLL_API void setAudio(void* ptr, bool flag);
    NTKINECTDLL_API float getBeamAngle(void* ptr);
    NTKINECTDLL_API float getBeamAngleConfidence(void* ptr);
    NTKINECTDLL_API void openAudio(void* ptr, wchar_t* filename);
    NTKINECTDLL_API void closeAudio(void* ptr);
    NTKINECTDLL_API bool isOpenedAudio(void* ptr);

    // RGB
    NTKINECTDLL_API void setRGB(void* ptr);
    NTKINECTDLL_API int getRGB(void* ptr, void* data);

    // Depth
    NTKINECTDLL_API void setDepth(void* ptr);
    NTKINECTDLL_API int getDepth(void* ptr, void* data);

    // Infrared
    NTKINECTDLL_API void setInfrared(void* ptr);
    NTKINECTDLL_API int getInfrared(void* ptr, void* data);

    // BodyIndex
    NTKINECTDLL_API void setBodyIndex(void* ptr);
    NTKINECTDLL_API int getBodyIndex(void* ptr, void* data);
    
    // Skeleton
    NTKINECTDLL_API void setSkeleton(void* ptr);
    NTKINECTDLL_API int getSkeleton(void* ptr, float* skelton, int* state, int* id, void* tid);
    NTKINECTDLL_API int handState(void* ptr,int id,bool isLeft);
    
    // Face
    NTKINECTDLL_API void setFace(void* ptr, bool flag);
    NTKINECTDLL_API int getFace(void* ptr, float* point,float* rect,float* direction,int* property,void* tid);

    // HDFace
    NTKINECTDLL_API void setHDFace(void* ptr, bool isColorSpace);
    NTKINECTDLL_API int getHDFace(void* ptr, float* point, void* tid,int *status);
    
    // Gesture
    NTKINECTDLL_API void setGestureFile(void* ptr, wchar_t* filename);
    NTKINECTDLL_API int setGestureId(void* ptr, wchar_t* name, int id); // id: non-zero
    NTKINECTDLL_API void setGesture(void* ptr);
    NTKINECTDLL_API int getDiscreteGesture(void* ptr, int* gid, float* confidence);
    NTKINECTDLL_API int getContinuousGesture(void* ptr, int* gid, float* progress);
    NTKINECTDLL_API int getGidMapSize();
  }
  std::unordered_map<std::string, int> gidMap;
}
